package zio.aws.lightsail.model
import java.lang.Integer
import zio.aws.lightsail.model.primitives.{
  ContainerServiceScale,
  ContainerServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateContainerServiceRequest(
    serviceName: ContainerServiceName,
    power: Option[zio.aws.lightsail.model.ContainerServicePowerName] = None,
    scale: Option[ContainerServiceScale] = None,
    isDisabled: Option[Boolean] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest = {
    import UpdateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .optionallyWith(power.map(value => value.unwrap))(_.power)
      .optionallyWith(
        scale.map(value => ContainerServiceScale.unwrap(value): Integer)
      )(_.scale)
      .optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(
        _.isDisabled
      )
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateContainerServiceRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateContainerServiceRequest.wrap(buildAwsValue())
}
object UpdateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateContainerServiceRequest =
      zio.aws.lightsail.model.UpdateContainerServiceRequest(
        serviceName,
        power.map(value => value),
        scale.map(value => value),
        isDisabled.map(value => value),
        publicDomainNames.map(value => value)
      )
    def serviceName: ContainerServiceName
    def power: Option[zio.aws.lightsail.model.ContainerServicePowerName]
    def scale: Option[ContainerServiceScale]
    def isDisabled: Option[Boolean]
    def publicDomainNames: Option[Map[String, List[String]]]
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getPower: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServicePowerName
    ] = AwsError.unwrapOptionField("power", power)
    def getScale: ZIO[Any, AwsError, ContainerServiceScale] =
      AwsError.unwrapOptionField("scale", scale)
    def getIsDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDisabled", isDisabled)
    def getPublicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ) extends zio.aws.lightsail.model.UpdateContainerServiceRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val power
        : Option[zio.aws.lightsail.model.ContainerServicePowerName] = scala
      .Option(impl.power())
      .map(value =>
        zio.aws.lightsail.model.ContainerServicePowerName.wrap(value)
      )
    override val scale: Option[ContainerServiceScale] = scala
      .Option(impl.scale())
      .map(value =>
        zio.aws.lightsail.model.primitives.ContainerServiceScale(value)
      )
    override val isDisabled: Option[Boolean] =
      scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override val publicDomainNames: Option[Map[String, List[String]]] = scala
      .Option(impl.publicDomainNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest
  ): zio.aws.lightsail.model.UpdateContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
