package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{StringMax256, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateLoadBalancerAttributeRequest(
    loadBalancerName: ResourceName,
    attributeName: zio.aws.lightsail.model.LoadBalancerAttributeName,
    attributeValue: StringMax256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest = {
    import UpdateLoadBalancerAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .attributeName(attributeName.unwrap)
      .attributeValue(StringMax256.unwrap(attributeValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest
      .wrap(buildAwsValue())
}
object UpdateLoadBalancerAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest =
      zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest(
        loadBalancerName,
        attributeName,
        attributeValue
      )
    def loadBalancerName: ResourceName
    def attributeName: zio.aws.lightsail.model.LoadBalancerAttributeName
    def attributeValue: StringMax256
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getAttributeName
        : ZIO[Any, Nothing, zio.aws.lightsail.model.LoadBalancerAttributeName] =
      ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, Nothing, StringMax256] =
      ZIO.succeed(attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ) extends zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val attributeName
        : zio.aws.lightsail.model.LoadBalancerAttributeName =
      zio.aws.lightsail.model.LoadBalancerAttributeName
        .wrap(impl.attributeName())
    override val attributeValue: StringMax256 =
      zio.aws.lightsail.model.primitives.StringMax256(impl.attributeValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest
  ): zio.aws.lightsail.model.UpdateLoadBalancerAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
