package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRelationalDatabaseParametersRequest(
    relationalDatabaseName: ResourceName,
    parameters: Iterable[zio.aws.lightsail.model.RelationalDatabaseParameter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest = {
    import UpdateRelationalDatabaseParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest
      .wrap(buildAwsValue())
}
object UpdateRelationalDatabaseParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest =
      zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest(
        relationalDatabaseName,
        parameters.map { item =>
          item.asEditable
        }
      )
    def relationalDatabaseName: ResourceName
    def parameters
        : List[zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getParameters: ZIO[Any, Nothing, List[
      zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]] = ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ) extends zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val parameters
        : List[zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly] =
      impl
        .parameters()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.RelationalDatabaseParameter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ): zio.aws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly =
    new Wrapper(impl)
}
