package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteGeofenceResponse(
    errors: Iterable[zio.aws.location.model.BatchDeleteGeofenceError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse = {
    import BatchDeleteGeofenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly =
    zio.aws.location.model.BatchDeleteGeofenceResponse.wrap(buildAwsValue())
}
object BatchDeleteGeofenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchDeleteGeofenceResponse =
      zio.aws.location.model.BatchDeleteGeofenceResponse(errors.map { item =>
        item.asEditable
      })
    def errors: List[zio.aws.location.model.BatchDeleteGeofenceError.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchDeleteGeofenceError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse
  ) extends zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly {
    override val errors
        : List[zio.aws.location.model.BatchDeleteGeofenceError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.location.model.BatchDeleteGeofenceError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteGeofenceResponse
  ): zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly = new Wrapper(
    impl
  )
}
