package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class BatchEvaluateGeofencesRequest(
    collectionName: ResourceName,
    devicePositionUpdates: Iterable[zio.aws.location.model.DevicePositionUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest = {
    import BatchEvaluateGeofencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .devicePositionUpdates(devicePositionUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchEvaluateGeofencesRequest.ReadOnly =
    zio.aws.location.model.BatchEvaluateGeofencesRequest.wrap(buildAwsValue())
}
object BatchEvaluateGeofencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchEvaluateGeofencesRequest =
      zio.aws.location.model.BatchEvaluateGeofencesRequest(
        collectionName,
        devicePositionUpdates.map { item =>
          item.asEditable
        }
      )
    def collectionName: ResourceName
    def devicePositionUpdates
        : List[zio.aws.location.model.DevicePositionUpdate.ReadOnly]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getDevicePositionUpdates: ZIO[Any, Nothing, List[
      zio.aws.location.model.DevicePositionUpdate.ReadOnly
    ]] = ZIO.succeed(devicePositionUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest
  ) extends zio.aws.location.model.BatchEvaluateGeofencesRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val devicePositionUpdates
        : List[zio.aws.location.model.DevicePositionUpdate.ReadOnly] = impl
      .devicePositionUpdates()
      .asScala
      .map { item =>
        zio.aws.location.model.DevicePositionUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesRequest
  ): zio.aws.location.model.BatchEvaluateGeofencesRequest.ReadOnly =
    new Wrapper(impl)
}
