package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetDevicePositionResponse(
    devicePositions: Iterable[zio.aws.location.model.DevicePosition],
    errors: Iterable[zio.aws.location.model.BatchGetDevicePositionError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse = {
    import BatchGetDevicePositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse
      .builder()
      .devicePositions(devicePositions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly =
    zio.aws.location.model.BatchGetDevicePositionResponse.wrap(buildAwsValue())
}
object BatchGetDevicePositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchGetDevicePositionResponse =
      zio.aws.location.model.BatchGetDevicePositionResponse(
        devicePositions.map { item =>
          item.asEditable
        },
        errors.map { item =>
          item.asEditable
        }
      )
    def devicePositions: List[zio.aws.location.model.DevicePosition.ReadOnly]
    def errors
        : List[zio.aws.location.model.BatchGetDevicePositionError.ReadOnly]
    def getDevicePositions: ZIO[Any, Nothing, List[
      zio.aws.location.model.DevicePosition.ReadOnly
    ]] = ZIO.succeed(devicePositions)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchGetDevicePositionError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse
  ) extends zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly {
    override val devicePositions
        : List[zio.aws.location.model.DevicePosition.ReadOnly] = impl
      .devicePositions()
      .asScala
      .map { item =>
        zio.aws.location.model.DevicePosition.wrap(item)
      }
      .toList
    override val errors
        : List[zio.aws.location.model.BatchGetDevicePositionError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.location.model.BatchGetDevicePositionError.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchGetDevicePositionResponse
  ): zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly =
    new Wrapper(impl)
}
