package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchItemError(
    code: Option[zio.aws.location.model.BatchItemErrorCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchItemError = {
    import BatchItemError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchItemError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchItemError.ReadOnly =
    zio.aws.location.model.BatchItemError.wrap(buildAwsValue())
}
object BatchItemError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchItemError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchItemError =
      zio.aws.location.model
        .BatchItemError(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.location.model.BatchItemErrorCode]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, zio.aws.location.model.BatchItemErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchItemError
  ) extends zio.aws.location.model.BatchItemError.ReadOnly {
    override val code: Option[zio.aws.location.model.BatchItemErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.location.model.BatchItemErrorCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchItemError
  ): zio.aws.location.model.BatchItemError.ReadOnly = new Wrapper(impl)
}
