package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceRequestEntry(
    geofenceId: Id,
    geometry: zio.aws.location.model.GeofenceGeometry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry = {
    import BatchPutGeofenceRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
      .builder()
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .geometry(geometry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceRequestEntry.wrap(buildAwsValue())
}
object BatchPutGeofenceRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceRequestEntry =
      zio.aws.location.model
        .BatchPutGeofenceRequestEntry(geofenceId, geometry.asEditable)
    def geofenceId: Id
    def geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.GeofenceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ) extends zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly {
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly =
      zio.aws.location.model.GeofenceGeometry.wrap(impl.geometry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ): zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly = new Wrapper(
    impl
  )
}
