package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceResponse(
    errors: Iterable[zio.aws.location.model.BatchPutGeofenceError],
    successes: Iterable[zio.aws.location.model.BatchPutGeofenceSuccess]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse = {
    import BatchPutGeofenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .successes(successes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceResponse.wrap(buildAwsValue())
}
object BatchPutGeofenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceResponse =
      zio.aws.location.model.BatchPutGeofenceResponse(
        errors.map { item =>
          item.asEditable
        },
        successes.map { item =>
          item.asEditable
        }
      )
    def errors: List[zio.aws.location.model.BatchPutGeofenceError.ReadOnly]
    def successes: List[zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchPutGeofenceError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getSuccesses: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly
    ]] = ZIO.succeed(successes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse
  ) extends zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly {
    override val errors
        : List[zio.aws.location.model.BatchPutGeofenceError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.location.model.BatchPutGeofenceError.wrap(item)
      }
      .toList
    override val successes
        : List[zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly] = impl
      .successes()
      .asScala
      .map { item =>
        zio.aws.location.model.BatchPutGeofenceSuccess.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceResponse
  ): zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly = new Wrapper(
    impl
  )
}
