package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CalculateRouteCarModeOptions(
    avoidFerries: Option[Boolean] = None,
    avoidTolls: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions = {
    import CalculateRouteCarModeOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions
      .builder()
      .optionallyWith(avoidFerries.map(value => value: java.lang.Boolean))(
        _.avoidFerries
      )
      .optionallyWith(avoidTolls.map(value => value: java.lang.Boolean))(
        _.avoidTolls
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly =
    zio.aws.location.model.CalculateRouteCarModeOptions.wrap(buildAwsValue())
}
object CalculateRouteCarModeOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteCarModeOptions =
      zio.aws.location.model.CalculateRouteCarModeOptions(
        avoidFerries.map(value => value),
        avoidTolls.map(value => value)
      )
    def avoidFerries: Option[Boolean]
    def avoidTolls: Option[Boolean]
    def getAvoidFerries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidFerries", avoidFerries)
    def getAvoidTolls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidTolls", avoidTolls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions
  ) extends zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly {
    override val avoidFerries: Option[Boolean] =
      scala.Option(impl.avoidFerries()).map(value => value: Boolean)
    override val avoidTolls: Option[Boolean] =
      scala.Option(impl.avoidTolls()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteCarModeOptions
  ): zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly = new Wrapper(
    impl
  )
}
