package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CalculateRouteMatrixResponse(
    routeMatrix: Iterable[Iterable[zio.aws.location.model.RouteMatrixEntry]],
    snappedDeparturePositions: Option[Iterable[Iterable[Double]]] = None,
    snappedDestinationPositions: Option[Iterable[Iterable[Double]]] = None,
    summary: zio.aws.location.model.CalculateRouteMatrixSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse = {
    import CalculateRouteMatrixResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse
      .builder()
      .routeMatrix(routeMatrix.map { item =>
        item.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      }.asJavaCollection)
      .optionallyWith(
        snappedDeparturePositions.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.snappedDeparturePositions)
      .optionallyWith(
        snappedDestinationPositions.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.snappedDestinationPositions)
      .summary(summary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly =
    zio.aws.location.model.CalculateRouteMatrixResponse.wrap(buildAwsValue())
}
object CalculateRouteMatrixResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteMatrixResponse =
      zio.aws.location.model.CalculateRouteMatrixResponse(
        routeMatrix.map { item =>
          item.map { item =>
            item.asEditable
          }
        },
        snappedDeparturePositions.map(value => value),
        snappedDestinationPositions.map(value => value),
        summary.asEditable
      )
    def routeMatrix
        : List[List[zio.aws.location.model.RouteMatrixEntry.ReadOnly]]
    def snappedDeparturePositions: Option[List[List[Double]]]
    def snappedDestinationPositions: Option[List[List[Double]]]
    def summary: zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly
    def getRouteMatrix: ZIO[Any, Nothing, List[
      List[zio.aws.location.model.RouteMatrixEntry.ReadOnly]
    ]] = ZIO.succeed(routeMatrix)
    def getSnappedDeparturePositions: ZIO[Any, AwsError, List[List[Double]]] =
      AwsError.unwrapOptionField(
        "snappedDeparturePositions",
        snappedDeparturePositions
      )
    def getSnappedDestinationPositions: ZIO[Any, AwsError, List[List[Double]]] =
      AwsError.unwrapOptionField(
        "snappedDestinationPositions",
        snappedDestinationPositions
      )
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly
    ] = ZIO.succeed(summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse
  ) extends zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly {
    override val routeMatrix
        : List[List[zio.aws.location.model.RouteMatrixEntry.ReadOnly]] = impl
      .routeMatrix()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          zio.aws.location.model.RouteMatrixEntry.wrap(item)
        }.toList
      }
      .toList
    override val snappedDeparturePositions: Option[List[List[Double]]] = scala
      .Option(impl.snappedDeparturePositions())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item: Double
          }.toList
        }.toList
      )
    override val snappedDestinationPositions: Option[List[List[Double]]] = scala
      .Option(impl.snappedDestinationPositions())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item: Double
          }.toList
        }.toList
      )
    override val summary
        : zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly =
      zio.aws.location.model.CalculateRouteMatrixSummary.wrap(impl.summary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixResponse
  ): zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly = new Wrapper(
    impl
  )
}
