package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CalculateRouteTruckModeOptions(
    avoidFerries: Option[Boolean] = None,
    avoidTolls: Option[Boolean] = None,
    dimensions: Option[zio.aws.location.model.TruckDimensions] = None,
    weight: Option[zio.aws.location.model.TruckWeight] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions = {
    import CalculateRouteTruckModeOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
      .builder()
      .optionallyWith(avoidFerries.map(value => value: java.lang.Boolean))(
        _.avoidFerries
      )
      .optionallyWith(avoidTolls.map(value => value: java.lang.Boolean))(
        _.avoidTolls
      )
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(weight.map(value => value.buildAwsValue()))(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly =
    zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(buildAwsValue())
}
object CalculateRouteTruckModeOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteTruckModeOptions =
      zio.aws.location.model.CalculateRouteTruckModeOptions(
        avoidFerries.map(value => value),
        avoidTolls.map(value => value),
        dimensions.map(value => value.asEditable),
        weight.map(value => value.asEditable)
      )
    def avoidFerries: Option[Boolean]
    def avoidTolls: Option[Boolean]
    def dimensions: Option[zio.aws.location.model.TruckDimensions.ReadOnly]
    def weight: Option[zio.aws.location.model.TruckWeight.ReadOnly]
    def getAvoidFerries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidFerries", avoidFerries)
    def getAvoidTolls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidTolls", avoidTolls)
    def getDimensions
        : ZIO[Any, AwsError, zio.aws.location.model.TruckDimensions.ReadOnly] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getWeight
        : ZIO[Any, AwsError, zio.aws.location.model.TruckWeight.ReadOnly] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ) extends zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly {
    override val avoidFerries: Option[Boolean] =
      scala.Option(impl.avoidFerries()).map(value => value: Boolean)
    override val avoidTolls: Option[Boolean] =
      scala.Option(impl.avoidTolls()).map(value => value: Boolean)
    override val dimensions
        : Option[zio.aws.location.model.TruckDimensions.ReadOnly] = scala
      .Option(impl.dimensions())
      .map(value => zio.aws.location.model.TruckDimensions.wrap(value))
    override val weight: Option[zio.aws.location.model.TruckWeight.ReadOnly] =
      scala
        .Option(impl.weight())
        .map(value => zio.aws.location.model.TruckWeight.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ): zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly =
    new Wrapper(impl)
}
