package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  ResourceDescription,
  TagValue,
  KmsKeyId,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateGeofenceCollectionRequest(
    collectionName: ResourceName,
    description: Option[ResourceDescription] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    pricingPlanDataSource: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest = {
    import CreateGeofenceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly =
    zio.aws.location.model.CreateGeofenceCollectionRequest.wrap(buildAwsValue())
}
object CreateGeofenceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateGeofenceCollectionRequest =
      zio.aws.location.model.CreateGeofenceCollectionRequest(
        collectionName,
        description.map(value => value),
        kmsKeyId.map(value => value),
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        tags.map(value => value)
      )
    def collectionName: ResourceName
    def description: Option[ResourceDescription]
    def kmsKeyId: Option[KmsKeyId]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ) extends zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Option[String] =
      scala.Option(impl.pricingPlanDataSource()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ): zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
