package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  TagValue,
  TagKey,
  ResourceName,
  ResourceDescription
}
import scala.jdk.CollectionConverters._
final case class CreateMapRequest(
    configuration: zio.aws.location.model.MapConfiguration,
    description: Option[ResourceDescription] = None,
    mapName: ResourceName,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateMapRequest = {
    import CreateMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateMapRequest
      .builder()
      .configuration(configuration.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateMapRequest.ReadOnly =
    zio.aws.location.model.CreateMapRequest.wrap(buildAwsValue())
}
object CreateMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateMapRequest =
      zio.aws.location.model.CreateMapRequest(
        configuration.asEditable,
        description.map(value => value),
        mapName,
        pricingPlan.map(value => value),
        tags.map(value => value)
      )
    def configuration: zio.aws.location.model.MapConfiguration.ReadOnly
    def description: Option[ResourceDescription]
    def mapName: ResourceName
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def tags: Option[Map[TagKey, TagValue]]
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.location.model.MapConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateMapRequest
  ) extends zio.aws.location.model.CreateMapRequest.ReadOnly {
    override val configuration
        : zio.aws.location.model.MapConfiguration.ReadOnly =
      zio.aws.location.model.MapConfiguration.wrap(impl.configuration())
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateMapRequest
  ): zio.aws.location.model.CreateMapRequest.ReadOnly = new Wrapper(impl)
}
