package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  TagValue,
  TagKey,
  ResourceName,
  ResourceDescription
}
import scala.jdk.CollectionConverters._
final case class CreatePlaceIndexRequest(
    dataSource: String,
    dataSourceConfiguration: Option[
      zio.aws.location.model.DataSourceConfiguration
    ] = None,
    description: Option[ResourceDescription] = None,
    indexName: ResourceName,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest = {
    import CreatePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
      .builder()
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        dataSourceConfiguration.map(value => value.buildAwsValue())
      )(_.dataSourceConfiguration)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.CreatePlaceIndexRequest.wrap(buildAwsValue())
}
object CreatePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreatePlaceIndexRequest =
      zio.aws.location.model.CreatePlaceIndexRequest(
        dataSource,
        dataSourceConfiguration.map(value => value.asEditable),
        description.map(value => value),
        indexName,
        pricingPlan.map(value => value),
        tags.map(value => value)
      )
    def dataSource: String
    def dataSourceConfiguration
        : Option[zio.aws.location.model.DataSourceConfiguration.ReadOnly]
    def description: Option[ResourceDescription]
    def indexName: ResourceName
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def tags: Option[Map[TagKey, TagValue]]
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDataSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceConfiguration",
      dataSourceConfiguration
    )
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ) extends zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly {
    override val dataSource: String = impl.dataSource(): String
    override val dataSourceConfiguration
        : Option[zio.aws.location.model.DataSourceConfiguration.ReadOnly] =
      scala
        .Option(impl.dataSourceConfiguration())
        .map(value =>
          zio.aws.location.model.DataSourceConfiguration.wrap(value)
        )
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ): zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly = new Wrapper(impl)
}
