package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataSourceConfiguration(
    intendedUse: Option[zio.aws.location.model.IntendedUse] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DataSourceConfiguration = {
    import DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DataSourceConfiguration
      .builder()
      .optionallyWith(intendedUse.map(value => value.unwrap))(_.intendedUse)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DataSourceConfiguration.ReadOnly =
    zio.aws.location.model.DataSourceConfiguration.wrap(buildAwsValue())
}
object DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DataSourceConfiguration =
      zio.aws.location.model
        .DataSourceConfiguration(intendedUse.map(value => value))
    def intendedUse: Option[zio.aws.location.model.IntendedUse]
    def getIntendedUse: ZIO[Any, AwsError, zio.aws.location.model.IntendedUse] =
      AwsError.unwrapOptionField("intendedUse", intendedUse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DataSourceConfiguration
  ) extends zio.aws.location.model.DataSourceConfiguration.ReadOnly {
    override val intendedUse: Option[zio.aws.location.model.IntendedUse] = scala
      .Option(impl.intendedUse())
      .map(value => zio.aws.location.model.IntendedUse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DataSourceConfiguration
  ): zio.aws.location.model.DataSourceConfiguration.ReadOnly = new Wrapper(impl)
}
