package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteGeofenceCollectionRequest(collectionName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest = {
    import DeleteGeofenceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DeleteGeofenceCollectionRequest.ReadOnly =
    zio.aws.location.model.DeleteGeofenceCollectionRequest.wrap(buildAwsValue())
}
object DeleteGeofenceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteGeofenceCollectionRequest =
      zio.aws.location.model.DeleteGeofenceCollectionRequest(collectionName)
    def collectionName: ResourceName
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest
  ) extends zio.aws.location.model.DeleteGeofenceCollectionRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteGeofenceCollectionRequest
  ): zio.aws.location.model.DeleteGeofenceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
