package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  KmsKeyId,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeGeofenceCollectionResponse(
    collectionArn: Arn,
    collectionName: ResourceName,
    createTime: Timestamp,
    description: ResourceDescription,
    kmsKeyId: Option[KmsKeyId] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    pricingPlanDataSource: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse = {
    import DescribeGeofenceCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
      .builder()
      .collectionArn(Arn.unwrap(collectionArn): java.lang.String)
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly =
    zio.aws.location.model.DescribeGeofenceCollectionResponse
      .wrap(buildAwsValue())
}
object DescribeGeofenceCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeGeofenceCollectionResponse =
      zio.aws.location.model.DescribeGeofenceCollectionResponse(
        collectionArn,
        collectionName,
        createTime,
        description,
        kmsKeyId.map(value => value),
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        tags.map(value => value),
        updateTime
      )
    def collectionArn: Arn
    def collectionName: ResourceName
    def createTime: Timestamp
    def description: ResourceDescription
    def kmsKeyId: Option[KmsKeyId]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def updateTime: Timestamp
    def getCollectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(collectionArn)
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ) extends zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly {
    override val collectionArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.collectionArn())
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Option[String] =
      scala.Option(impl.pricingPlanDataSource()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ): zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
