package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribePlaceIndexResponse(
    createTime: Timestamp,
    dataSource: String,
    dataSourceConfiguration: zio.aws.location.model.DataSourceConfiguration,
    description: ResourceDescription,
    indexArn: Arn,
    indexName: ResourceName,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse = {
    import DescribePlaceIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .dataSourceConfiguration(dataSourceConfiguration.buildAwsValue())
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .indexArn(Arn.unwrap(indexArn): java.lang.String)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly =
    zio.aws.location.model.DescribePlaceIndexResponse.wrap(buildAwsValue())
}
object DescribePlaceIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribePlaceIndexResponse =
      zio.aws.location.model.DescribePlaceIndexResponse(
        createTime,
        dataSource,
        dataSourceConfiguration.asEditable,
        description,
        indexArn,
        indexName,
        pricingPlan.map(value => value),
        tags.map(value => value),
        updateTime
      )
    def createTime: Timestamp
    def dataSource: String
    def dataSourceConfiguration
        : zio.aws.location.model.DataSourceConfiguration.ReadOnly
    def description: ResourceDescription
    def indexArn: Arn
    def indexName: ResourceName
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def tags: Option[Map[TagKey, TagValue]]
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDataSourceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.DataSourceConfiguration.ReadOnly
    ] = ZIO.succeed(dataSourceConfiguration)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getIndexArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(indexArn)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse
  ) extends zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val dataSource: String = impl.dataSource(): String
    override val dataSourceConfiguration
        : zio.aws.location.model.DataSourceConfiguration.ReadOnly =
      zio.aws.location.model.DataSourceConfiguration
        .wrap(impl.dataSourceConfiguration())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val indexArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.indexArn())
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribePlaceIndexResponse
  ): zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
