package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  KmsKeyId,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeTrackerResponse(
    createTime: Timestamp,
    description: ResourceDescription,
    kmsKeyId: Option[KmsKeyId] = None,
    positionFiltering: Option[zio.aws.location.model.PositionFiltering] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    pricingPlanDataSource: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    trackerArn: Arn,
    trackerName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeTrackerResponse = {
    import DescribeTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeTrackerResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(positionFiltering.map(value => value.unwrap))(
        _.positionFiltering
      )
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .trackerArn(Arn.unwrap(trackerArn): java.lang.String)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeTrackerResponse.ReadOnly =
    zio.aws.location.model.DescribeTrackerResponse.wrap(buildAwsValue())
}
object DescribeTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeTrackerResponse =
      zio.aws.location.model.DescribeTrackerResponse(
        createTime,
        description,
        kmsKeyId.map(value => value),
        positionFiltering.map(value => value),
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        tags.map(value => value),
        trackerArn,
        trackerName,
        updateTime
      )
    def createTime: Timestamp
    def description: ResourceDescription
    def kmsKeyId: Option[KmsKeyId]
    def positionFiltering: Option[zio.aws.location.model.PositionFiltering]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def trackerArn: Arn
    def trackerName: ResourceName
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPositionFiltering
        : ZIO[Any, AwsError, zio.aws.location.model.PositionFiltering] =
      AwsError.unwrapOptionField("positionFiltering", positionFiltering)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTrackerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(trackerArn)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ) extends zio.aws.location.model.DescribeTrackerResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val positionFiltering
        : Option[zio.aws.location.model.PositionFiltering] = scala
      .Option(impl.positionFiltering())
      .map(value => zio.aws.location.model.PositionFiltering.wrap(value))
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Option[String] =
      scala.Option(impl.pricingPlanDataSource()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val trackerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.trackerArn())
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ): zio.aws.location.model.DescribeTrackerResponse.ReadOnly = new Wrapper(impl)
}
