package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class DisassociateTrackerConsumerRequest(
    consumerArn: Arn,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest = {
    import DisassociateTrackerConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest
      .builder()
      .consumerArn(Arn.unwrap(consumerArn): java.lang.String)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DisassociateTrackerConsumerRequest.ReadOnly =
    zio.aws.location.model.DisassociateTrackerConsumerRequest
      .wrap(buildAwsValue())
}
object DisassociateTrackerConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DisassociateTrackerConsumerRequest =
      zio.aws.location.model
        .DisassociateTrackerConsumerRequest(consumerArn, trackerName)
    def consumerArn: Arn
    def trackerName: ResourceName
    def getConsumerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(consumerArn)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest
  ) extends zio.aws.location.model.DisassociateTrackerConsumerRequest.ReadOnly {
    override val consumerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.consumerArn())
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DisassociateTrackerConsumerRequest
  ): zio.aws.location.model.DisassociateTrackerConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
