package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GeofenceGeometry(
    polygon: Option[Iterable[Iterable[Iterable[Double]]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GeofenceGeometry = {
    import GeofenceGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GeofenceGeometry
      .builder()
      .optionallyWith(
        polygon.map(value =>
          value.map { item =>
            item.map { item =>
              item.map { item =>
                item: java.lang.Double
              }.asJavaCollection
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.polygon)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GeofenceGeometry.ReadOnly =
    zio.aws.location.model.GeofenceGeometry.wrap(buildAwsValue())
}
object GeofenceGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GeofenceGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GeofenceGeometry =
      zio.aws.location.model.GeofenceGeometry(polygon.map(value => value))
    def polygon: Option[List[List[List[Double]]]]
    def getPolygon: ZIO[Any, AwsError, List[List[List[Double]]]] =
      AwsError.unwrapOptionField("polygon", polygon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ) extends zio.aws.location.model.GeofenceGeometry.ReadOnly {
    override val polygon: Option[List[List[List[Double]]]] = scala
      .Option(impl.polygon())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item.asScala.map { item =>
              item: Double
            }.toList
          }.toList
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ): zio.aws.location.model.GeofenceGeometry.ReadOnly = new Wrapper(impl)
}
