package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.location.model.primitives.{ResourceName, Token, Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class GetDevicePositionHistoryRequest(
    deviceId: Id,
    endTimeExclusive: Option[Timestamp] = None,
    nextToken: Option[Token] = None,
    startTimeInclusive: Option[Timestamp] = None,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest = {
    import GetDevicePositionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .optionallyWith(
        endTimeExclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimeExclusive)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        startTimeInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimeInclusive)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly =
    zio.aws.location.model.GetDevicePositionHistoryRequest.wrap(buildAwsValue())
}
object GetDevicePositionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionHistoryRequest =
      zio.aws.location.model.GetDevicePositionHistoryRequest(
        deviceId,
        endTimeExclusive.map(value => value),
        nextToken.map(value => value),
        startTimeInclusive.map(value => value),
        trackerName
      )
    def deviceId: Id
    def endTimeExclusive: Option[Timestamp]
    def nextToken: Option[Token]
    def startTimeInclusive: Option[Timestamp]
    def trackerName: ResourceName
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getEndTimeExclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimeExclusive", endTimeExclusive)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTimeInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimeInclusive", startTimeInclusive)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ) extends zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val endTimeExclusive: Option[Timestamp] = scala
      .Option(impl.endTimeExclusive())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val startTimeInclusive: Option[Timestamp] = scala
      .Option(impl.startTimeInclusive())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ): zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
