package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Id, ResourceName}
import scala.jdk.CollectionConverters._
final case class GetGeofenceRequest(
    collectionName: ResourceName,
    geofenceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetGeofenceRequest = {
    import GetGeofenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetGeofenceRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetGeofenceRequest.ReadOnly =
    zio.aws.location.model.GetGeofenceRequest.wrap(buildAwsValue())
}
object GetGeofenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetGeofenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetGeofenceRequest =
      zio.aws.location.model.GetGeofenceRequest(collectionName, geofenceId)
    def collectionName: ResourceName
    def geofenceId: Id
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetGeofenceRequest
  ) extends zio.aws.location.model.GetGeofenceRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetGeofenceRequest
  ): zio.aws.location.model.GetGeofenceRequest.ReadOnly = new Wrapper(impl)
}
