package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Id, Timestamp}
import scala.jdk.CollectionConverters._
final case class GetGeofenceResponse(
    createTime: Timestamp,
    geofenceId: Id,
    geometry: zio.aws.location.model.GeofenceGeometry,
    status: String,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetGeofenceResponse = {
    import GetGeofenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetGeofenceResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .geometry(geometry.buildAwsValue())
      .status(status: java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetGeofenceResponse.ReadOnly =
    zio.aws.location.model.GetGeofenceResponse.wrap(buildAwsValue())
}
object GetGeofenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetGeofenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetGeofenceResponse =
      zio.aws.location.model.GetGeofenceResponse(
        createTime,
        geofenceId,
        geometry.asEditable,
        status,
        updateTime
      )
    def createTime: Timestamp
    def geofenceId: Id
    def geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly
    def status: String
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.GeofenceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetGeofenceResponse
  ) extends zio.aws.location.model.GetGeofenceResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly =
      zio.aws.location.model.GeofenceGeometry.wrap(impl.geometry())
    override val status: String = impl.status(): String
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetGeofenceResponse
  ): zio.aws.location.model.GetGeofenceResponse.ReadOnly = new Wrapper(impl)
}
