package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  ResourceName,
  GetMapGlyphsRequestFontUnicodeRangeString
}
import scala.jdk.CollectionConverters._
final case class GetMapGlyphsRequest(
    fontStack: String,
    fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString,
    mapName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapGlyphsRequest = {
    import GetMapGlyphsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
      .builder()
      .fontStack(fontStack: java.lang.String)
      .fontUnicodeRange(
        GetMapGlyphsRequestFontUnicodeRangeString.unwrap(
          fontUnicodeRange
        ): java.lang.String
      )
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapGlyphsRequest.ReadOnly =
    zio.aws.location.model.GetMapGlyphsRequest.wrap(buildAwsValue())
}
object GetMapGlyphsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapGlyphsRequest =
      zio.aws.location.model
        .GetMapGlyphsRequest(fontStack, fontUnicodeRange, mapName)
    def fontStack: String
    def fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString
    def mapName: ResourceName
    def getFontStack: ZIO[Any, Nothing, String] = ZIO.succeed(fontStack)
    def getFontUnicodeRange
        : ZIO[Any, Nothing, GetMapGlyphsRequestFontUnicodeRangeString] =
      ZIO.succeed(fontUnicodeRange)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ) extends zio.aws.location.model.GetMapGlyphsRequest.ReadOnly {
    override val fontStack: String = impl.fontStack(): String
    override val fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString =
      zio.aws.location.model.primitives
        .GetMapGlyphsRequestFontUnicodeRangeString(impl.fontUnicodeRange())
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ): zio.aws.location.model.GetMapGlyphsRequest.ReadOnly = new Wrapper(impl)
}
