package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.Blob
import scala.jdk.CollectionConverters._
final case class GetMapSpritesResponse(
    blob: Option[Blob] = None,
    contentType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapSpritesResponse = {
    import GetMapSpritesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapSpritesResponse
      .builder()
      .optionallyWith(
        blob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.blob)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapSpritesResponse.ReadOnly =
    zio.aws.location.model.GetMapSpritesResponse.wrap(buildAwsValue())
}
object GetMapSpritesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapSpritesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapSpritesResponse =
      zio.aws.location.model.GetMapSpritesResponse(
        blob.map(value => value),
        contentType.map(value => value)
      )
    def blob: Option[Blob]
    def contentType: Option[String]
    def getBlob: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blob", blob)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesResponse
  ) extends zio.aws.location.model.GetMapSpritesResponse.ReadOnly {
    override val blob: Option[Blob] = scala
      .Option(impl.blob())
      .map(value =>
        zio.aws.location.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesResponse
  ): zio.aws.location.model.GetMapSpritesResponse.ReadOnly = new Wrapper(impl)
}
