package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class GetMapStyleDescriptorRequest(mapName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest = {
    import GetMapStyleDescriptorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly =
    zio.aws.location.model.GetMapStyleDescriptorRequest.wrap(buildAwsValue())
}
object GetMapStyleDescriptorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapStyleDescriptorRequest =
      zio.aws.location.model.GetMapStyleDescriptorRequest(mapName)
    def mapName: ResourceName
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ) extends zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ): zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly = new Wrapper(
    impl
  )
}
