package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.Blob
import scala.jdk.CollectionConverters._
final case class GetMapStyleDescriptorResponse(
    blob: Option[Blob] = None,
    contentType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse = {
    import GetMapStyleDescriptorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
      .builder()
      .optionallyWith(
        blob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.blob)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly =
    zio.aws.location.model.GetMapStyleDescriptorResponse.wrap(buildAwsValue())
}
object GetMapStyleDescriptorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapStyleDescriptorResponse =
      zio.aws.location.model.GetMapStyleDescriptorResponse(
        blob.map(value => value),
        contentType.map(value => value)
      )
    def blob: Option[Blob]
    def contentType: Option[String]
    def getBlob: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blob", blob)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ) extends zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly {
    override val blob: Option[Blob] = scala
      .Option(impl.blob())
      .map(value =>
        zio.aws.location.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ): zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly =
    new Wrapper(impl)
}
