package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  GetMapTileRequestZString,
  GetMapTileRequestYString,
  GetMapTileRequestXString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetMapTileRequest(
    mapName: ResourceName,
    x: GetMapTileRequestXString,
    y: GetMapTileRequestYString,
    z: GetMapTileRequestZString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapTileRequest = {
    import GetMapTileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapTileRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .x(GetMapTileRequestXString.unwrap(x): java.lang.String)
      .y(GetMapTileRequestYString.unwrap(y): java.lang.String)
      .z(GetMapTileRequestZString.unwrap(z): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapTileRequest.ReadOnly =
    zio.aws.location.model.GetMapTileRequest.wrap(buildAwsValue())
}
object GetMapTileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapTileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapTileRequest =
      zio.aws.location.model.GetMapTileRequest(mapName, x, y, z)
    def mapName: ResourceName
    def x: GetMapTileRequestXString
    def y: GetMapTileRequestYString
    def z: GetMapTileRequestZString
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getX: ZIO[Any, Nothing, GetMapTileRequestXString] = ZIO.succeed(x)
    def getY: ZIO[Any, Nothing, GetMapTileRequestYString] = ZIO.succeed(y)
    def getZ: ZIO[Any, Nothing, GetMapTileRequestZString] = ZIO.succeed(z)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapTileRequest
  ) extends zio.aws.location.model.GetMapTileRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val x: GetMapTileRequestXString =
      zio.aws.location.model.primitives.GetMapTileRequestXString(impl.x())
    override val y: GetMapTileRequestYString =
      zio.aws.location.model.primitives.GetMapTileRequestYString(impl.y())
    override val z: GetMapTileRequestZString =
      zio.aws.location.model.primitives.GetMapTileRequestZString(impl.z())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapTileRequest
  ): zio.aws.location.model.GetMapTileRequest.ReadOnly = new Wrapper(impl)
}
