package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  ResourceName,
  Token,
  ListDevicePositionsRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters._
final case class ListDevicePositionsRequest(
    maxResults: Option[ListDevicePositionsRequestMaxResultsInteger] = None,
    nextToken: Option[Token] = None,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListDevicePositionsRequest = {
    import ListDevicePositionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListDevicePositionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListDevicePositionsRequest.ReadOnly =
    zio.aws.location.model.ListDevicePositionsRequest.wrap(buildAwsValue())
}
object ListDevicePositionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListDevicePositionsRequest =
      zio.aws.location.model.ListDevicePositionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        trackerName
      )
    def maxResults: Option[ListDevicePositionsRequestMaxResultsInteger]
    def nextToken: Option[Token]
    def trackerName: ResourceName
    def getMaxResults
        : ZIO[Any, AwsError, ListDevicePositionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ) extends zio.aws.location.model.ListDevicePositionsRequest.ReadOnly {
    override val maxResults
        : Option[ListDevicePositionsRequestMaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.location.model.primitives
          .ListDevicePositionsRequestMaxResultsInteger(value)
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ): zio.aws.location.model.ListDevicePositionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
