package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{Token, ResourceName}
import scala.jdk.CollectionConverters._
final case class ListGeofencesRequest(
    collectionName: ResourceName,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListGeofencesRequest = {
    import ListGeofencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListGeofencesRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListGeofencesRequest.ReadOnly =
    zio.aws.location.model.ListGeofencesRequest.wrap(buildAwsValue())
}
object ListGeofencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListGeofencesRequest =
      zio.aws.location.model
        .ListGeofencesRequest(collectionName, nextToken.map(value => value))
    def collectionName: ResourceName
    def nextToken: Option[Token]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ) extends zio.aws.location.model.ListGeofencesRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ): zio.aws.location.model.ListGeofencesRequest.ReadOnly = new Wrapper(impl)
}
