package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  Token,
  ListPlaceIndexesRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters._
final case class ListPlaceIndexesRequest(
    maxResults: Option[ListPlaceIndexesRequestMaxResultsInteger] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest = {
    import ListPlaceIndexesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListPlaceIndexesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly =
    zio.aws.location.model.ListPlaceIndexesRequest.wrap(buildAwsValue())
}
object ListPlaceIndexesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListPlaceIndexesRequest =
      zio.aws.location.model.ListPlaceIndexesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListPlaceIndexesRequestMaxResultsInteger]
    def nextToken: Option[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListPlaceIndexesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ) extends zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly {
    override val maxResults: Option[ListPlaceIndexesRequestMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListPlaceIndexesRequestMaxResultsInteger(value)
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ): zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly = new Wrapper(impl)
}
