package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.location.model.primitives.{
  ResourceName,
  ResourceDescription,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class ListPlaceIndexesResponseEntry(
    createTime: Timestamp,
    dataSource: String,
    description: ResourceDescription,
    indexName: ResourceName,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry = {
    import ListPlaceIndexesResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly =
    zio.aws.location.model.ListPlaceIndexesResponseEntry.wrap(buildAwsValue())
}
object ListPlaceIndexesResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListPlaceIndexesResponseEntry =
      zio.aws.location.model.ListPlaceIndexesResponseEntry(
        createTime,
        dataSource,
        description,
        indexName,
        pricingPlan.map(value => value),
        updateTime
      )
    def createTime: Timestamp
    def dataSource: String
    def description: ResourceDescription
    def indexName: ResourceName
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry
  ) extends zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val dataSource: String = impl.dataSource(): String
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesResponseEntry
  ): zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly =
    new Wrapper(impl)
}
