package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  Token,
  ListRouteCalculatorsRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters._
final case class ListRouteCalculatorsRequest(
    maxResults: Option[ListRouteCalculatorsRequestMaxResultsInteger] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest = {
    import ListRouteCalculatorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListRouteCalculatorsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly =
    zio.aws.location.model.ListRouteCalculatorsRequest.wrap(buildAwsValue())
}
object ListRouteCalculatorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListRouteCalculatorsRequest =
      zio.aws.location.model.ListRouteCalculatorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListRouteCalculatorsRequestMaxResultsInteger]
    def nextToken: Option[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListRouteCalculatorsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ) extends zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly {
    override val maxResults
        : Option[ListRouteCalculatorsRequestMaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.location.model.primitives
          .ListRouteCalculatorsRequestMaxResultsInteger(value)
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ): zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly = new Wrapper(
    impl
  )
}
