package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  Token,
  ListTrackersRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters._
final case class ListTrackersRequest(
    maxResults: Option[ListTrackersRequestMaxResultsInteger] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackersRequest = {
    import ListTrackersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListTrackersRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackersRequest.ReadOnly =
    zio.aws.location.model.ListTrackersRequest.wrap(buildAwsValue())
}
object ListTrackersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackersRequest =
      zio.aws.location.model.ListTrackersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListTrackersRequestMaxResultsInteger]
    def nextToken: Option[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListTrackersRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackersRequest
  ) extends zio.aws.location.model.ListTrackersRequest.ReadOnly {
    override val maxResults: Option[ListTrackersRequestMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListTrackersRequestMaxResultsInteger(value)
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackersRequest
  ): zio.aws.location.model.ListTrackersRequest.ReadOnly = new Wrapper(impl)
}
