package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListTrackersResponse(
    entries: Iterable[zio.aws.location.model.ListTrackersResponseEntry],
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackersResponse = {
    import ListTrackersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackersResponse
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackersResponse.ReadOnly =
    zio.aws.location.model.ListTrackersResponse.wrap(buildAwsValue())
}
object ListTrackersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackersResponse =
      zio.aws.location.model.ListTrackersResponse(
        entries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entries: List[zio.aws.location.model.ListTrackersResponseEntry.ReadOnly]
    def nextToken: Option[Token]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackersResponse
  ) extends zio.aws.location.model.ListTrackersResponse.ReadOnly {
    override val entries
        : List[zio.aws.location.model.ListTrackersResponseEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.location.model.ListTrackersResponseEntry.wrap(item)
      }
      .toList
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackersResponse
  ): zio.aws.location.model.ListTrackersResponse.ReadOnly = new Wrapper(impl)
}
