package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Place(
    addressNumber: Option[String] = None,
    country: Option[String] = None,
    geometry: zio.aws.location.model.PlaceGeometry,
    interpolated: Option[Boolean] = None,
    label: Option[String] = None,
    municipality: Option[String] = None,
    neighborhood: Option[String] = None,
    postalCode: Option[String] = None,
    region: Option[String] = None,
    street: Option[String] = None,
    subRegion: Option[String] = None,
    timeZone: Option[zio.aws.location.model.TimeZone] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Place = {
    import Place.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Place
      .builder()
      .optionallyWith(addressNumber.map(value => value: java.lang.String))(
        _.addressNumber
      )
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .geometry(geometry.buildAwsValue())
      .optionallyWith(interpolated.map(value => value: java.lang.Boolean))(
        _.interpolated
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(municipality.map(value => value: java.lang.String))(
        _.municipality
      )
      .optionallyWith(neighborhood.map(value => value: java.lang.String))(
        _.neighborhood
      )
      .optionallyWith(postalCode.map(value => value: java.lang.String))(
        _.postalCode
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(street.map(value => value: java.lang.String))(_.street)
      .optionallyWith(subRegion.map(value => value: java.lang.String))(
        _.subRegion
      )
      .optionallyWith(timeZone.map(value => value.buildAwsValue()))(_.timeZone)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Place.ReadOnly =
    zio.aws.location.model.Place.wrap(buildAwsValue())
}
object Place {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Place] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Place = zio.aws.location.model.Place(
      addressNumber.map(value => value),
      country.map(value => value),
      geometry.asEditable,
      interpolated.map(value => value),
      label.map(value => value),
      municipality.map(value => value),
      neighborhood.map(value => value),
      postalCode.map(value => value),
      region.map(value => value),
      street.map(value => value),
      subRegion.map(value => value),
      timeZone.map(value => value.asEditable)
    )
    def addressNumber: Option[String]
    def country: Option[String]
    def geometry: zio.aws.location.model.PlaceGeometry.ReadOnly
    def interpolated: Option[Boolean]
    def label: Option[String]
    def municipality: Option[String]
    def neighborhood: Option[String]
    def postalCode: Option[String]
    def region: Option[String]
    def street: Option[String]
    def subRegion: Option[String]
    def timeZone: Option[zio.aws.location.model.TimeZone.ReadOnly]
    def getAddressNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressNumber", addressNumber)
    def getCountry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("country", country)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.PlaceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
    def getInterpolated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interpolated", interpolated)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getMunicipality: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("municipality", municipality)
    def getNeighborhood: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("neighborhood", neighborhood)
    def getPostalCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getStreet: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street", street)
    def getSubRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subRegion", subRegion)
    def getTimeZone
        : ZIO[Any, AwsError, zio.aws.location.model.TimeZone.ReadOnly] =
      AwsError.unwrapOptionField("timeZone", timeZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Place
  ) extends zio.aws.location.model.Place.ReadOnly {
    override val addressNumber: Option[String] =
      scala.Option(impl.addressNumber()).map(value => value: String)
    override val country: Option[String] =
      scala.Option(impl.country()).map(value => value: String)
    override val geometry: zio.aws.location.model.PlaceGeometry.ReadOnly =
      zio.aws.location.model.PlaceGeometry.wrap(impl.geometry())
    override val interpolated: Option[Boolean] =
      scala.Option(impl.interpolated()).map(value => value: Boolean)
    override val label: Option[String] =
      scala.Option(impl.label()).map(value => value: String)
    override val municipality: Option[String] =
      scala.Option(impl.municipality()).map(value => value: String)
    override val neighborhood: Option[String] =
      scala.Option(impl.neighborhood()).map(value => value: String)
    override val postalCode: Option[String] =
      scala.Option(impl.postalCode()).map(value => value: String)
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override val street: Option[String] =
      scala.Option(impl.street()).map(value => value: String)
    override val subRegion: Option[String] =
      scala.Option(impl.subRegion()).map(value => value: String)
    override val timeZone: Option[zio.aws.location.model.TimeZone.ReadOnly] =
      scala
        .Option(impl.timeZone())
        .map(value => zio.aws.location.model.TimeZone.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Place
  ): zio.aws.location.model.Place.ReadOnly = new Wrapper(impl)
}
