package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait PositionFiltering {
  def unwrap: software.amazon.awssdk.services.location.model.PositionFiltering
}
object PositionFiltering {
  def wrap(
      value: software.amazon.awssdk.services.location.model.PositionFiltering
  ): zio.aws.location.model.PositionFiltering = value match {
    case software.amazon.awssdk.services.location.model.PositionFiltering.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.PositionFiltering.TIME_BASED =>
      val r = TimeBased
      r
    case software.amazon.awssdk.services.location.model.PositionFiltering.DISTANCE_BASED =>
      val r = DistanceBased
      r
    case software.amazon.awssdk.services.location.model.PositionFiltering.ACCURACY_BASED =>
      val r = AccuracyBased
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.PositionFiltering {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PositionFiltering =
      software.amazon.awssdk.services.location.model.PositionFiltering.UNKNOWN_TO_SDK_VERSION
  }
  case object TimeBased extends zio.aws.location.model.PositionFiltering {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PositionFiltering =
      software.amazon.awssdk.services.location.model.PositionFiltering.TIME_BASED
  }
  case object DistanceBased extends zio.aws.location.model.PositionFiltering {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PositionFiltering =
      software.amazon.awssdk.services.location.model.PositionFiltering.DISTANCE_BASED
  }
  case object AccuracyBased extends zio.aws.location.model.PositionFiltering {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PositionFiltering =
      software.amazon.awssdk.services.location.model.PositionFiltering.ACCURACY_BASED
  }
}
