package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  RouteMatrixEntryDurationSecondsDouble,
  RouteMatrixEntryDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class RouteMatrixEntry(
    distance: Option[RouteMatrixEntryDistanceDouble] = None,
    durationSeconds: Option[RouteMatrixEntryDurationSecondsDouble] = None,
    error: Option[zio.aws.location.model.RouteMatrixEntryError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.RouteMatrixEntry = {
    import RouteMatrixEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.RouteMatrixEntry
      .builder()
      .optionallyWith(
        distance.map(value =>
          RouteMatrixEntryDistanceDouble.unwrap(value): java.lang.Double
        )
      )(_.distance)
      .optionallyWith(
        durationSeconds.map(value =>
          RouteMatrixEntryDurationSecondsDouble.unwrap(value): java.lang.Double
        )
      )(_.durationSeconds)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.location.model.RouteMatrixEntry.ReadOnly =
    zio.aws.location.model.RouteMatrixEntry.wrap(buildAwsValue())
}
object RouteMatrixEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.RouteMatrixEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.RouteMatrixEntry =
      zio.aws.location.model.RouteMatrixEntry(
        distance.map(value => value),
        durationSeconds.map(value => value),
        error.map(value => value.asEditable)
      )
    def distance: Option[RouteMatrixEntryDistanceDouble]
    def durationSeconds: Option[RouteMatrixEntryDurationSecondsDouble]
    def error: Option[zio.aws.location.model.RouteMatrixEntryError.ReadOnly]
    def getDistance: ZIO[Any, AwsError, RouteMatrixEntryDistanceDouble] =
      AwsError.unwrapOptionField("distance", distance)
    def getDurationSeconds
        : ZIO[Any, AwsError, RouteMatrixEntryDurationSecondsDouble] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.RouteMatrixEntryError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.RouteMatrixEntry
  ) extends zio.aws.location.model.RouteMatrixEntry.ReadOnly {
    override val distance: Option[RouteMatrixEntryDistanceDouble] = scala
      .Option(impl.distance())
      .map(value =>
        zio.aws.location.model.primitives.RouteMatrixEntryDistanceDouble(value)
      )
    override val durationSeconds
        : Option[RouteMatrixEntryDurationSecondsDouble] = scala
      .Option(impl.durationSeconds())
      .map(value =>
        zio.aws.location.model.primitives
          .RouteMatrixEntryDurationSecondsDouble(value)
      )
    override val error
        : Option[zio.aws.location.model.RouteMatrixEntryError.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.location.model.RouteMatrixEntryError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.RouteMatrixEntry
  ): zio.aws.location.model.RouteMatrixEntry.ReadOnly = new Wrapper(impl)
}
