package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  PlaceIndexSearchResultLimit,
  LanguageTag,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForPositionRequest(
    indexName: ResourceName,
    language: Option[LanguageTag] = None,
    maxResults: Option[PlaceIndexSearchResultLimit] = None,
    position: Iterable[Double]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest = {
    import SearchPlaceIndexForPositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForPositionRequest
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForPositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForPositionRequest =
      zio.aws.location.model.SearchPlaceIndexForPositionRequest(
        indexName,
        language.map(value => value),
        maxResults.map(value => value),
        position
      )
    def indexName: ResourceName
    def language: Option[LanguageTag]
    def maxResults: Option[PlaceIndexSearchResultLimit]
    def position: List[Double]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ) extends zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val language: Option[LanguageTag] = scala
      .Option(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults: Option[PlaceIndexSearchResultLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
      )
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionRequest
  ): zio.aws.location.model.SearchPlaceIndexForPositionRequest.ReadOnly =
    new Wrapper(impl)
}
