package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  PlaceIndexSearchResultLimit,
  LanguageTag
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForPositionSummary(
    dataSource: String,
    language: Option[LanguageTag] = None,
    maxResults: Option[PlaceIndexSearchResultLimit] = None,
    position: Iterable[Double]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary = {
    import SearchPlaceIndexForPositionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
      .builder()
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForPositionSummary
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForPositionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForPositionSummary =
      zio.aws.location.model.SearchPlaceIndexForPositionSummary(
        dataSource,
        language.map(value => value),
        maxResults.map(value => value),
        position
      )
    def dataSource: String
    def language: Option[LanguageTag]
    def maxResults: Option[PlaceIndexSearchResultLimit]
    def position: List[Double]
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly {
    override val dataSource: String = impl.dataSource(): String
    override val language: Option[LanguageTag] = scala
      .Option(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults: Option[PlaceIndexSearchResultLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
      )
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary
  ): zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly =
    new Wrapper(impl)
}
