package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  SyntheticSearchPlaceIndexForSuggestionsSummaryString,
  Integer,
  LanguageTag,
  CountryCode
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsSummary(
    biasPosition: Option[Iterable[Double]] = None,
    dataSource: String,
    filterBBox: Option[Iterable[Double]] = None,
    filterCountries: Option[Iterable[CountryCode]] = None,
    language: Option[LanguageTag] = None,
    maxResults: Option[Integer] = None,
    text: SyntheticSearchPlaceIndexForSuggestionsSummaryString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary = {
    import SearchPlaceIndexForSuggestionsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
      .builder()
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .text(
        SyntheticSearchPlaceIndexForSuggestionsSummaryString.unwrap(
          text
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary(
        biasPosition.map(value => value),
        dataSource,
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        language.map(value => value),
        maxResults.map(value => value),
        text
      )
    def biasPosition: Option[List[Double]]
    def dataSource: String
    def filterBBox: Option[List[Double]]
    def filterCountries: Option[List[CountryCode]]
    def language: Option[LanguageTag]
    def maxResults: Option[Integer]
    def text: SyntheticSearchPlaceIndexForSuggestionsSummaryString
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getText: ZIO[
      Any,
      Nothing,
      SyntheticSearchPlaceIndexForSuggestionsSummaryString
    ] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly {
    override val biasPosition: Option[List[Double]] = scala
      .Option(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val dataSource: String = impl.dataSource(): String
    override val filterBBox: Option[List[Double]] = scala
      .Option(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Option[List[CountryCode]] = scala
      .Option(impl.filterCountries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.primitives.CountryCode(item)
        }.toList
      )
    override val language: Option[LanguageTag] = scala
      .Option(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val text: SyntheticSearchPlaceIndexForSuggestionsSummaryString =
      zio.aws.location.model.primitives
        .SyntheticSearchPlaceIndexForSuggestionsSummaryString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    new Wrapper(impl)
}
