package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  SyntheticSearchPlaceIndexForTextSummaryString,
  PlaceIndexSearchResultLimit,
  LanguageTag,
  CountryCode
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForTextSummary(
    biasPosition: Option[Iterable[Double]] = None,
    dataSource: String,
    filterBBox: Option[Iterable[Double]] = None,
    filterCountries: Option[Iterable[CountryCode]] = None,
    language: Option[LanguageTag] = None,
    maxResults: Option[PlaceIndexSearchResultLimit] = None,
    resultBBox: Option[Iterable[Double]] = None,
    text: SyntheticSearchPlaceIndexForTextSummaryString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary = {
    import SearchPlaceIndexForTextSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
      .builder()
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        maxResults.map(value =>
          PlaceIndexSearchResultLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        resultBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.resultBBox)
      .text(
        SyntheticSearchPlaceIndexForTextSummaryString.unwrap(
          text
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForTextSummary.wrap(buildAwsValue())
}
object SearchPlaceIndexForTextSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForTextSummary =
      zio.aws.location.model.SearchPlaceIndexForTextSummary(
        biasPosition.map(value => value),
        dataSource,
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        language.map(value => value),
        maxResults.map(value => value),
        resultBBox.map(value => value),
        text
      )
    def biasPosition: Option[List[Double]]
    def dataSource: String
    def filterBBox: Option[List[Double]]
    def filterCountries: Option[List[CountryCode]]
    def language: Option[LanguageTag]
    def maxResults: Option[PlaceIndexSearchResultLimit]
    def resultBBox: Option[List[Double]]
    def text: SyntheticSearchPlaceIndexForTextSummaryString
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[Any, AwsError, PlaceIndexSearchResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResultBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("resultBBox", resultBBox)
    def getText
        : ZIO[Any, Nothing, SyntheticSearchPlaceIndexForTextSummaryString] =
      ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly {
    override val biasPosition: Option[List[Double]] = scala
      .Option(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val dataSource: String = impl.dataSource(): String
    override val filterBBox: Option[List[Double]] = scala
      .Option(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Option[List[CountryCode]] = scala
      .Option(impl.filterCountries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.primitives.CountryCode(item)
        }.toList
      )
    override val language: Option[LanguageTag] = scala
      .Option(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults: Option[PlaceIndexSearchResultLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.location.model.primitives.PlaceIndexSearchResultLimit(value)
      )
    override val resultBBox: Option[List[Double]] = scala
      .Option(impl.resultBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val text: SyntheticSearchPlaceIndexForTextSummaryString =
      zio.aws.location.model.primitives
        .SyntheticSearchPlaceIndexForTextSummaryString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextSummary
  ): zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
    new Wrapper(impl)
}
