package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{
  StepGeometryOffsetInteger,
  StepDurationSecondsDouble,
  StepDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class Step(
    distance: StepDistanceDouble,
    durationSeconds: StepDurationSecondsDouble,
    endPosition: Iterable[Double],
    geometryOffset: Option[StepGeometryOffsetInteger] = None,
    startPosition: Iterable[Double]
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Step = {
    import Step.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Step
      .builder()
      .distance(StepDistanceDouble.unwrap(distance): java.lang.Double)
      .durationSeconds(
        StepDurationSecondsDouble.unwrap(durationSeconds): java.lang.Double
      )
      .endPosition(endPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        geometryOffset.map(value =>
          StepGeometryOffsetInteger.unwrap(value): Integer
        )
      )(_.geometryOffset)
      .startPosition(startPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Step.ReadOnly =
    zio.aws.location.model.Step.wrap(buildAwsValue())
}
object Step {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Step] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Step = zio.aws.location.model.Step(
      distance,
      durationSeconds,
      endPosition,
      geometryOffset.map(value => value),
      startPosition
    )
    def distance: StepDistanceDouble
    def durationSeconds: StepDurationSecondsDouble
    def endPosition: List[Double]
    def geometryOffset: Option[StepGeometryOffsetInteger]
    def startPosition: List[Double]
    def getDistance: ZIO[Any, Nothing, StepDistanceDouble] =
      ZIO.succeed(distance)
    def getDurationSeconds: ZIO[Any, Nothing, StepDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getEndPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(endPosition)
    def getGeometryOffset: ZIO[Any, AwsError, StepGeometryOffsetInteger] =
      AwsError.unwrapOptionField("geometryOffset", geometryOffset)
    def getStartPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(startPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Step
  ) extends zio.aws.location.model.Step.ReadOnly {
    override val distance: StepDistanceDouble =
      zio.aws.location.model.primitives.StepDistanceDouble(impl.distance())
    override val durationSeconds: StepDurationSecondsDouble =
      zio.aws.location.model.primitives
        .StepDurationSecondsDouble(impl.durationSeconds())
    override val endPosition: List[Double] = impl
      .endPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val geometryOffset: Option[StepGeometryOffsetInteger] = scala
      .Option(impl.geometryOffset())
      .map(value =>
        zio.aws.location.model.primitives.StepGeometryOffsetInteger(value)
      )
    override val startPosition: List[Double] = impl
      .startPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Step
  ): zio.aws.location.model.Step.ReadOnly = new Wrapper(impl)
}
