package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class TimeZone(name: String, offset: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TimeZone = {
    import TimeZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TimeZone
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(offset.map(value => value: java.lang.Integer))(_.offset)
      .build()
  }
  def asReadOnly: zio.aws.location.model.TimeZone.ReadOnly =
    zio.aws.location.model.TimeZone.wrap(buildAwsValue())
}
object TimeZone {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.TimeZone] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TimeZone =
      zio.aws.location.model.TimeZone(name, offset.map(value => value))
    def name: String
    def offset: Option[Integer]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("offset", offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TimeZone
  ) extends zio.aws.location.model.TimeZone.ReadOnly {
    override val name: String = impl.name(): String
    override val offset: Option[Integer] =
      scala.Option(impl.offset()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TimeZone
  ): zio.aws.location.model.TimeZone.ReadOnly = new Wrapper(impl)
}
