package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.TruckWeightTotalDouble
import scala.jdk.CollectionConverters._
final case class TruckWeight(
    total: Option[TruckWeightTotalDouble] = None,
    unit: Option[zio.aws.location.model.VehicleWeightUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TruckWeight = {
    import TruckWeight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TruckWeight
      .builder()
      .optionallyWith(
        total.map(value =>
          TruckWeightTotalDouble.unwrap(value): java.lang.Double
        )
      )(_.total)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.location.model.TruckWeight.ReadOnly =
    zio.aws.location.model.TruckWeight.wrap(buildAwsValue())
}
object TruckWeight {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.TruckWeight
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TruckWeight = zio.aws.location.model
      .TruckWeight(total.map(value => value), unit.map(value => value))
    def total: Option[TruckWeightTotalDouble]
    def unit: Option[zio.aws.location.model.VehicleWeightUnit]
    def getTotal: ZIO[Any, AwsError, TruckWeightTotalDouble] =
      AwsError.unwrapOptionField("total", total)
    def getUnit: ZIO[Any, AwsError, zio.aws.location.model.VehicleWeightUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TruckWeight
  ) extends zio.aws.location.model.TruckWeight.ReadOnly {
    override val total: Option[TruckWeightTotalDouble] = scala
      .Option(impl.total())
      .map(value =>
        zio.aws.location.model.primitives.TruckWeightTotalDouble(value)
      )
    override val unit: Option[zio.aws.location.model.VehicleWeightUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.location.model.VehicleWeightUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TruckWeight
  ): zio.aws.location.model.TruckWeight.ReadOnly = new Wrapper(impl)
}
