package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateGeofenceCollectionRequest(
    collectionName: ResourceName,
    description: Option[ResourceDescription] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    pricingPlanDataSource: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest = {
    import UpdateGeofenceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.UpdateGeofenceCollectionRequest.ReadOnly =
    zio.aws.location.model.UpdateGeofenceCollectionRequest.wrap(buildAwsValue())
}
object UpdateGeofenceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateGeofenceCollectionRequest =
      zio.aws.location.model.UpdateGeofenceCollectionRequest(
        collectionName,
        description.map(value => value),
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value)
      )
    def collectionName: ResourceName
    def description: Option[ResourceDescription]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Option[String]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest
  ) extends zio.aws.location.model.UpdateGeofenceCollectionRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Option[String] =
      scala.Option(impl.pricingPlanDataSource()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionRequest
  ): zio.aws.location.model.UpdateGeofenceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
