package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateGeofenceCollectionResponse(
    collectionArn: Arn,
    collectionName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse = {
    import UpdateGeofenceCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse
      .builder()
      .collectionArn(Arn.unwrap(collectionArn): java.lang.String)
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly =
    zio.aws.location.model.UpdateGeofenceCollectionResponse
      .wrap(buildAwsValue())
}
object UpdateGeofenceCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateGeofenceCollectionResponse =
      zio.aws.location.model.UpdateGeofenceCollectionResponse(
        collectionArn,
        collectionName,
        updateTime
      )
    def collectionArn: Arn
    def collectionName: ResourceName
    def updateTime: Timestamp
    def getCollectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(collectionArn)
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse
  ) extends zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly {
    override val collectionArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.collectionArn())
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateGeofenceCollectionResponse
  ): zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
