package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{ResourceName, ResourceDescription}
import scala.jdk.CollectionConverters._
final case class UpdatePlaceIndexRequest(
    dataSourceConfiguration: Option[
      zio.aws.location.model.DataSourceConfiguration
    ] = None,
    description: Option[ResourceDescription] = None,
    indexName: ResourceName,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest = {
    import UpdatePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
      .builder()
      .optionallyWith(
        dataSourceConfiguration.map(value => value.buildAwsValue())
      )(_.dataSourceConfiguration)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.UpdatePlaceIndexRequest.wrap(buildAwsValue())
}
object UpdatePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdatePlaceIndexRequest =
      zio.aws.location.model.UpdatePlaceIndexRequest(
        dataSourceConfiguration.map(value => value.asEditable),
        description.map(value => value),
        indexName,
        pricingPlan.map(value => value)
      )
    def dataSourceConfiguration
        : Option[zio.aws.location.model.DataSourceConfiguration.ReadOnly]
    def description: Option[ResourceDescription]
    def indexName: ResourceName
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def getDataSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceConfiguration",
      dataSourceConfiguration
    )
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ) extends zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly {
    override val dataSourceConfiguration
        : Option[zio.aws.location.model.DataSourceConfiguration.ReadOnly] =
      scala
        .Option(impl.dataSourceConfiguration())
        .map(value =>
          zio.aws.location.model.DataSourceConfiguration.wrap(value)
        )
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexRequest
  ): zio.aws.location.model.UpdatePlaceIndexRequest.ReadOnly = new Wrapper(impl)
}
